import importlib

attack_zoo = {
    'cwt': ('.input_transformation.cwt', 'CWT'),
}


def load_attack_class(attack_name):
    if attack_name not in attack_zoo:
        raise Exception('Unspported attack algorithm {}'.format(attack_name))
    module_path, class_name = attack_zoo[attack_name]
    module = importlib.import_module(module_path, __package__)
    attack_class = getattr(module, class_name)
    return attack_class


__version__ = '1.0.0'
